/* -*- mode: c -*- */
/*****************************************************************************
  ls11core.h : Declaration of the KOEI LS file manipulation functions.
  numdisp, 2010-04-10, rev 0.
*****************************************************************************/

#ifndef LS11CORE_H
#define LS11CORE_H 1
#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* Length of the LS file sections. */
#define LS_HEAD_LENGTH  16  /* The file head section. */
#define LS_DICT_LENGTH  256 /* The dictionary section. */

/* Types of the LS encoding algorithm. */
#define INVALID_LSTYPE  0
#define LS10TYPE        10
#define LS11TYPE        11
#define LS12TYPE        12

/* Declaration of the LS file manipulation functions. */
void swapednv(void *x, unsigned int size, unsigned int num);
int  get_ls_file_type(FILE *fp);
int  ls11_decode(unsigned char *dict, unsigned char *enc, int lenc,
                 unsigned char *dec, int ldec, int lstype);

#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* ls11core.h */

/*****************************************************************************
  End of the C header file : ls11core.h
*****************************************************************************/
